/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.crops.api;

import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.info.IC2Classic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import speiger.src.crops.api.ICropCardInfo;
import speiger.src.crops.api.ICropInfo;

public class CropPluginAPI {
    private static List<ICropInfo> TO_PROCESS = new ArrayList<ICropInfo>();
    private Map<CropCard, List<String>> extraInfos = new HashMap<CropCard, List<String>>();
    private Map<CropCard, ItemStack> displayItems = new HashMap<CropCard, ItemStack>();
    public static CropPluginAPI instance = new CropPluginAPI();

    public void registerCropInfo(ICropInfo info) {
        if (info != null) {
            TO_PROCESS.add(info);
        }
    }

    public ItemStack getDisplayItem(CropCard card) {
        return ItemStack.func_77944_b((ItemStack)this.displayItems.get(card));
    }

    public List<String> getExtraInfos(CropCard card) {
        List<String> info = this.extraInfos.get(card);
        if (info == null) {
            info = new ArrayList<String>();
        }
        return info;
    }

    public void load(Map<CropCard, ItemStack> par1, IC2Classic.IC2Type type) {
        for (ICropInfo target : TO_PROCESS) {
            List<CropCard> cards = target.getSupportedCrops();
            if (cards == null || cards.isEmpty()) continue;
            for (CropCard card : cards) {
                ItemStack item;
                List<String> data = target.getCropInformation(card);
                if (data != null && !data.isEmpty() && !this.extraInfos.containsKey(card)) {
                    this.extraInfos.put(card, data);
                }
                if ((item = target.getDisplayItems(card)) == null || this.displayItems.containsKey(card)) continue;
                item = item.func_77946_l();
                String name = card.displayName();
                if (type == IC2Classic.IC2Type.Experimental) {
                    name = StatCollector.func_74838_a((String)name);
                }
                CropPluginAPI.storeCrop(item, card);
                item.func_151001_c("Crop " + name);
                this.displayItems.put(card, item);
            }
        }
        TO_PROCESS.clear();
        for (CropCard card : par1.keySet()) {
            if (card instanceof ICropCardInfo) {
                ItemStack item;
                ICropCardInfo info = (ICropCardInfo)((Object)card);
                List<String> data = info.getCropInformation();
                if (data != null && !data.isEmpty()) {
                    this.extraInfos.put(card, data);
                }
                if ((item = info.getDisplayItem()) != null) {
                    item = item.func_77946_l();
                    String name = card.displayName();
                    if (type == IC2Classic.IC2Type.Experimental) {
                        name = StatCollector.func_74838_a((String)name);
                    }
                    item.func_151001_c("Crop " + name);
                    CropPluginAPI.storeCrop(item, card);
                    this.displayItems.put(card, item);
                }
            }
            if (this.displayItems.containsKey(card)) continue;
            ItemStack stack = par1.get(card).func_77946_l();
            CropPluginAPI.storeCrop(stack, card);
            this.displayItems.put(card, stack);
        }
    }

    public static void storeCrop(ItemStack stack, CropCard card) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Owner", card.owner());
        nbt.func_74778_a("Name", card.name());
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74782_a("BREED_INFO", (NBTBase)nbt);
    }

    public static CropCard getCrop(ItemStack stack) {
        CropCard card = Crops.instance.getCropCard(stack);
        if (card == null) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null || !nbt.func_74764_b("BREED_INFO")) {
                return null;
            }
            NBTTagCompound subTag = nbt.func_74775_l("BREED_INFO");
            card = Crops.instance.getCropCard(subTag.func_74779_i("Owner"), subTag.func_74779_i("Name"));
        }
        return card;
    }
}

